#!/bin/sh

# luna firmware upgrade  script
# $1 image destination (0 or 1) 
# Kernel and root file system images are assumed to be located at the same directory named uImage and rootfs respectively
# ToDo: use arugements to refer to kernel/rootfs location.

k_img="uImage"
r_img="rootfs"
img_ver="fwu_ver"
md5_cmp="md5.txt"
md5_cmd="/bin/md5sum"
#md5 run-time result
md5_tmp="md5_tmp" 
md5_rt_result="md5_rt_result.txt"

#added by abner on 2017-02-21
#modify by hdjy for v2801RW_GPON and v2802WT_GPON upgrade
tar -xf $2 $img_ver 

upgradeModel1=$(sed -n 2p $img_ver)
upgradeModel2=$(sed -n 3p $img_ver)
#add by hdjy for bug#0000617
upgradeModel3=$(sed -n 4p $img_ver)
echo "will upgrade mode : $upgradeModel1 or $upgradeModel2 or $upgradeModel3"

#if flash get EPON_ONU_MODEL | grep $upgradeModel; then 
if cat /var/config/lastgood_hs.xml | grep $upgradeModel1; then 
	echo "model is the same........"
elif cat /var/config/lastgood_hs.xml | grep $upgradeModel2; then
	echo "model is the same........"
#add by hdjy for bug#0000617
elif cat /var/config/lastgood_hs.xml | grep $upgradeModel3; then
	echo "model is the same........"
else
	echo "model is not the same........"
	reboot		#add by abner fro bug#0000505 on 2017-06-13
	exit 1
fi  
#end add

#add by abner for bug#0000584 on 2017-08-15
echo 0 > /proc/watchdog/watchdog_flag
killall vswdg
echo 1 > /proc/watchdog/vs_watchdog_flag
killall cwmpClient
killall spppd
killall vsntp
killall dnsmasq
killall udhcpd
killall igmp_pid
killall cwmp
killall wscd-wlan0
killall mini_upnpd
killall smbd
killall upnpmd_cp
killall iwcontrol
killall loopback
killall systemd
sleep 3
ps
# Added by Samson
# check if v2801hw
if 
        cat /proc/mtd | grep linux
then    
        kname="linux"
        rname="rootfs"
elif      
#it's v2801rw check if 16M flash
        cat /proc/mtd | grep k"$1"
then            
        kname="k"$1""
        rname="r"$1""
else
#it's 8M flash
        kname="k0"
        rname="r0"
#set commit image back to 0, 20161018
	nv setenv sw_commit "0"
fi
echo "==>$kname  ==>$rname"

# Stop this script upon any error
set -e

echo "Updating image $1 with file $2"

# Find out kernel/rootfs mtd partition according to image destination
# Modified by Samson for bug#000269 only one partion for each image 20160318.
#k_mtd="/dev/"`cat /proc/mtd | grep k"$1" | sed 's/:.*$//g'`
#r_mtd="/dev/"`cat /proc/mtd | grep r"$1" | sed 's/:.*$//g'`
#k_mtd="/dev/"`cat /proc/mtd | grep linux | sed 's/:.*$//g'`
#r_mtd="/dev/"`cat /proc/mtd | grep rootfs | sed 's/:.*$//g'`
k_mtd="/dev/"`cat /proc/mtd | grep "$kname" | sed 's/:.*$//g'`
r_mtd="/dev/"`cat /proc/mtd | grep "$rname" | sed 's/:.*$//g'`

#Ended by Samson.
echo "kernel image is located at $k_mtd"
echo "rootfs image is located at $r_mtd"

# Extract kernel image
tar -xf $2 $k_img -O | md5sum | sed 's/-/'$k_img'/g' > $md5_rt_result
# Check integrity
grep $k_img $md5_cmp > $md5_tmp
diff $md5_rt_result $md5_tmp

if [ $? != 0 ]; then
    echo "$k_img""md5_sum inconsistent, aborted image updating !"
    exit 1
fi

# Extract rootfs image
tar -xf $2 $r_img -O | md5sum | sed 's/-/'$r_img'/g' > $md5_rt_result
# Check integrity
grep $r_img $md5_cmp > $md5_tmp
diff $md5_rt_result $md5_tmp

if [ $? != 0 ]; then
    # rm $r_img
    echo "$r_img""md5_sum inconsistent, aborted image updating !"
    exit 1
fi

echo "Integrity of $k_img & $r_img is okay, start updating"

# Erase kernel partition 
flash_eraseall $k_mtd
# Write kernel partition
echo "Writing $k_img to $k_mtd"
tar -xf $2 $k_img -O > $k_mtd

# Erase rootfs partition 
flash_eraseall $r_mtd
# Write rootfs partition
echo "Writing $r_img to $r_mtd"
tar -xf $2 $r_img -O > $r_mtd

#add by abner for bug#0000584 on 2017-08-15
echo 2 > /proc/watchdog/vs_watchdog_flag
echo 1 > /proc/watchdog/watchdog_flag

# Write image version information 
#tar -xf $2 $img_ver 
#nv setenv sw_version"$1" "`cat $img_ver`"
nv setenv sw_version"$1" "$(sed -n 1p $img_ver)"		#modify by abner on 2017-02-21

# Clean up temporary files
rm -f $md5_cmp $md5_tmp $md5_rt_result $img_ver $2

# Post processing (for future extension consideration)

echo "Successfully updated image $1!!"

